

<?php $__env->startSection('title', 'Expert Bookkeeping & Accounting Services Tailored to Your Business'); ?>

<?php $__env->startSection('content'); ?>

<section class="service-facilites mt-2 pt-2 pb-2">
    <div class="auto-container">
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4">
                <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Expert Bookkeeping & Accounting Services <span>Tailored to Your Business</span></h2>
                    <p>At DXP Associates, we deliver reliable and efficient accounting solutions designed for startups, small businesses, and growing enterprises. Accurate financial management is key to making smart business decisions, staying compliant, and reaching your growth goals. Our experienced team is dedicated to simplifying your accounting process, saving you time and ensuring your records are precise.</p>
                </div>
                <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Trusted Financial Expertise That <span>Supports Your Growth</span></h2>
                    <p>Bookkeeping can be complex and time-consuming, but our professionals make it manageable. Whether you need short-term assistance or ongoing support, DXP Associates provides personalized services that help you maintain control and confidence over your finances—so you can focus on expanding your business.</p>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="service-facilites pt-0 pb-0">
    <div class="auto-container">
        <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
            <h2>Our Comprehensive <span>Accounting Services</span></h2>
            <p>We offer flexible, affordable solutions, including:</p>
        </div>
        <div class="row sp-service-facilites">
            <?php
                use Illuminate\Support\Facades\File;

                $jsonPath = public_path('/json/accounting-book-keeping.json'); 
                $json = File::get($jsonPath);
                $data = json_decode($json, true);
                $services = collect($data['features'])->sortBy('order')->values()->all();
            ?>

            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                    <div class="item">
                        <h2><a href="#"><?php echo e($service['title']); ?></a></h2>
                        <p><?php echo e($service['desc']); ?></p>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>The Value of <span>Professional Accounting</span></h2>
                    <p>Clear, accurate financial reporting is essential for evaluating your company’s financial health, making informed decisions, and responding promptly to new opportunities. By entrusting your bookkeeping and accounting to DXP Associates, you gain more than just record-keeping—you access valuable insights and save time, allowing your business to thrive.
Unlock your company's potential with DXP Associates. Reach out today to learn how our bookkeeping and accounting services can help your business grow with confidence.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php echo $__env->make('includes.pop-contactus', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('templates.page-template', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/httpdxpassociate/public_html/resources/views/accounting-book-keeping-solutions.blade.php ENDPATH**/ ?>